;       TI-Logo2   for ZShell                   (by Risto Jrvinen)
;       --------
;
;   Have you seen the TILOGO.85G?
;   Well... I made it smaller and faster using ZShell!
;   It's still as useless as it was originally!!!
;   But if you look carefully at the source you may find out that it decodes
; ZCP-crunched picture with my a bit optimized code.  I haven't calculated
; the clock cycles but I removed the use of ROM and memory.  Now it uses
; only registers and 2 bytes from stack (for moving HL to IX).
;   You can control the changing speed with Up/Down.
;   And last but not least: It's RibaWare; no copyright, 100% public domain.
; All rights wronged, all wrongs reversed.  Learn'n'Copy!
;
;   I, Risto Jrvinen, don't have my own email address so if you wish to
; contact me please use my friends address:
;
;       Jarno_Uurainen@llauta.fipnet.fi
;
;         +------------------------------+
;   NOTE: | DO NOT SEND ANY BIG FILES!!! |
;         +------------------------------+
;   One idiot sent to my friend a 2meg .WAV!  He receives his email via
; a BBS so sending mega-email causes messagepolling to take forever and
; sysop to go nuts.  If mega-stuff pops up place it on FTP and I'll leech
; it someday...  I don't think that You're an idiot (after all you propably
; have TI's calculator).  This is just a precaution :)
;

#include "ti-85.h"

.org    0
.db     "TI-Logo",0

Start:
   ROM_CALL(CLEARLCD)
   ld   HL,(PROGRAM_ADDR)
   ld   DE,PreZCP
   add  HL,DE
   push hl
   pop  ix                      ;IX = Address of packed data

; Entering this the routine at this address while holding the address of packed
; picture in IX you can use this routine for multi-picture viewing.

   ld   HL,VIDEO_MEM            ;HL = Address of video memory
   ld   C,%10000000             ;Set leftmost bit in C
Loop:
   ld   A,(ix)                  ;Get value from packed data
   inc  ix                      ;Advance packed data pointer
   cp   $00                     ;If value = 0...
   jr   Z,EndDecode             ;...then quit decoding
   ld   D,A                     ;...else save value to 'Data'
   bit  7,A                     ;If 7th bit is set
   jr   NZ,Copy                 ;...then it's a Copy chunk
   and  $3F                     ;...else it's a Stream chunk
   ld   B,A                     ;B = Lowest 6 bits of Data
   bit  6,D                     ;If 6th bit is set...
   jr   NZ,DrawStream           ;...then draw stream
   ld   A,B                     ;Advance video pointer
   srl  A
   srl  A
   srl  A
   add  A,L
   ld   L,A
   jr   NC,NoCarry
   inc  H
NoCarry:
   ld   A,B
   and  7                       ;rotate C right (B and 7) steps
   jr   Z,Loop                  ;if (B and 7) = 0 then don't rotate
   ld   B,A
RotLoop:
   rrc  C
   jr   NC,NoAdvPtr1            ;If rollover in C then increase HL
   inc  HL
NoAdvPtr1:
   djnz RotLoop
   jr   Loop
DrawStream:
   ld   A,C
   or   (HL)
   ld   (HL),A
   rrc  C
   jr   NC,NoAdvPtr2
   inc  HL
NoAdvPtr2:
   djnz DrawStream
   jr   Loop

Copy:
   ld   B,7                     ;Set counter for 7 bits of data
   sla  D                       ;Drop the extra bit off
CopyLoop:
   sla  D                       ;Move bits left, leftmost to Cf
   jr   NC,NotPut               ;If Not Cf then  Don't draw
   ld   A,C                     ;...else  Draw
   or   (HL)
   ld   (HL),A
NotPut:                                 ;In both cases increase video pointers
   rrc  C
   jr   NC,NoAdvPtr3
   inc  HL
NoAdvPtr3:
   djnz CopyLoop                ;Repeat until all 7 bits done
   jr   Loop

EndDecode:                      ;Picture decoded!
                                ;Start idle-stuff (reversing picture)

   ld   de,VIDEO_MEM

KeyLoop:
   call GET_KEY
   cp   K_EXIT
   ret  z
   cp   K_UP
   jr   nz,NoPlus
   ld   a,$ff
   cp   c
   jr   z,Done
   inc  c
   jr   Done
NoPlus:
   cp   K_DOWN
   jr   nz,Done
   ld   a,1
   cp   c
   jr   z,Done
   dec  c
Done:
   ld   b,c
Wait:
   nop\ nop\ nop\ nop\ nop\ nop\ nop\ nop       ;Lame-delay
   nop\ nop\ nop\ nop\ nop\ nop\ nop\ nop
   nop\ nop\ nop\ nop\ nop\ nop\ nop\ nop
   nop\ nop\ nop\ nop\ nop\ nop\ nop\ nop
   djnz Wait

   ld   a,(de)
   cpl
   ld   (de),a
   inc  de
   ld   a,0
   cp   d
   jr   z,EndDecode
   jr   KeyLoop

;--- ZCP encoder - Stephane JANTZEN - 12/95
;--- Beginning of ZCP data stream
PreZCP:
.db     $3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F,$3F
.db     $3F,$3F,$3F,$3F,$3F,$0D,$4F,$3F,$32,$4F,$3F,$32,$4F,$3F,$32,$4F
.db     $3F,$32,$4F,$3F,$32,$4F,$3F,$32,$4F,$3F,$32,$4F,$08,$F8,$3F,$23
.db     $4F,$80,$FC,$3F,$24,$4F,$80,$F8,$3F,$24,$53,$8F,$3F,$27,$52,$0C
.db     $4D,$3F,$16,$51,$0D,$4D,$3F,$16,$51,$8F,$C1,$4C,$3F,$16,$50,$87
.db     $E1,$4D,$3F,$16,$4D,$81,$F8,$83,$49,$3F,$16,$4C,$80,$FC,$81,$4A
.db     $3F,$16,$4C,$80,$FC,$81,$4A,$3F,$81,$5A,$08,$F8,$81,$4A,$3F,$80
.db     $5B,$81,$F8,$81,$4A,$3F,$80,$5D,$87,$E1,$4F,$3F,$08,$5C,$87,$E1
.db     $51,$3F,$81,$5B,$87,$C3,$51,$3F,$80,$5B,$8F,$C3,$51,$3F,$08,$59
.db     $87,$E3,$52,$3F,$09,$58,$87,$E3,$52,$3F,$0A,$57,$87,$E3,$52,$3F
.db     $0A,$57,$8F,$C3,$52,$3F,$0A,$56,$87,$E3,$53,$3F,$0B,$55,$87,$E3
.db     $53,$3F,$0B,$56,$0D,$53,$3F,$0C,$4B,$9F,$F0,$09,$53,$3F,$0C,$49
.db     $83,$FE,$0A,$51,$3F,$10,$FF,$81,$FF,$81,$53,$3F,$15,$E0,$8F,$5C
.db     $3F,$22,$5D,$3F,$24,$5B,$3F,$27,$59,$3F,$28,$57,$3F,$2A,$55,$3F
.db     $2D,$53,$3F,$2E,$53,$3F,$2F,$51,$3F,$31,$50,$3F,$32,$50,$3F,$32
.db     $4F,$3F,$33,$4E,$3F,$34,$4E,$3F,$34,$4D,$3F,$39,$FE,$00

;--- Data stream size : 253 bytes.


;insert your data here.

        .end
